/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.HMCBios;
import com.ibm.hsc.common.util.HMCPhysicalMem;
import com.ibm.hsc.common.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class HSCVPD {
    private HMCBios smbios;
    private byte[] tables = null;
    private byte[] VPDTable = null;
    private long VPDTableLength = 0L;

    public HSCVPD() throws HSCCIMException {
        this.readVPD();
        this.smbios = new HMCBios();
        this.tables = this.smbios.getTables();
    }

    public boolean isVPDPresent() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> isVPDPresent");
        }
        if (this.VPDTable != null) {
            return true;
        }
        return this.smbios.isSmbiosPresent();
    }

    public String getHSCMotherboard() {
        String string;
        int n;
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCMotherboard");
        }
        if (this.VPDTable != null) {
            if (this.VPDTable == null || this.VPDTableLength < 48L) {
                return "";
            }
            String string2 = new String(this.VPDTable, 29, 11);
            return string2.trim();
        }
        if (this.smbios.isSmbiosPresent() && (n = this.smbios.findNextStruct(-1, 2)) != -1 && (string = this.smbios.getSmbiosString(n, this.tables[n + 7])) != null && string.length() != 0) {
            return string.trim();
        }
        return "Unknow";
    }

    public String getHSCModel() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCModel");
        }
        if (this.VPDTable != null) {
            return new String(this.VPDTable, 40, 7);
        }
        if (this.smbios.isSmbiosPresent()) {
            String string;
            int n = this.smbios.findNextStruct(-1, 1);
            if (n != -1 && (string = this.smbios.getSmbiosString(n, this.tables[n + 5])) != null && string.length() != 0) {
                return string.trim();
            }
            n = this.smbios.findNextStruct(-1, 11);
            if (n != -1) {
                int n2 = HSCVPD.MakeUCHAR(this.tables[n + 4]);
                for (int i = 1; i <= n2; ++i) {
                    String string2 = this.smbios.getSmbiosString(n, i);
                    if (string2 == null || !string2.startsWith("Dell")) continue;
                    return string2.trim();
                }
            }
        }
        return null;
    }

    public String getHSCSerialNumber() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCSerialNumber");
        }
        if (this.VPDTable != null) {
            return new String(this.VPDTable, 22, 7);
        }
        if (this.smbios.isSmbiosPresent()) {
            String string;
            int n = this.smbios.findNextStruct(-1, 1);
            if (n != -1 && (string = this.smbios.getSmbiosString(n, this.tables[n + 7])) != null && string.length() != 0) {
                return string.trim();
            }
            n = this.smbios.findNextStruct(-1, 3);
            if (n != -1) {
                string = this.smbios.getSmbiosString(n, this.tables[n + 7]);
                if (string != null && string.length() != 0) {
                    return string.trim();
                }
                string = this.smbios.getSmbiosString(n, this.tables[n + 8]);
                if (string != null && string.length() != 0) {
                    return string.trim();
                }
            }
        }
        return null;
    }

    public String getHSCBIOS() {
        String string;
        int n;
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCBIOS");
        }
        if (this.VPDTable != null) {
            return new String(this.VPDTable, 13, 9);
        }
        if (this.smbios.isSmbiosPresent() && (n = this.smbios.findNextStruct(-1, 0)) != -1 && (string = this.smbios.getSmbiosString(n, this.tables[n + 5])) != null && string.length() != 0) {
            int n2 = string.indexOf("-[");
            int n3 = string.indexOf("]-");
            if (n2 != -1 && n3 != -1 && n2 + 2 < n3 && n3 - n2 > 9) {
                int n4 = (string = string.substring(n2 + 2, n3)).lastIndexOf(45);
                String string2 = n4 != -1 ? string.substring(0, n4) : string;
                return string2.trim();
            }
            return string.trim();
        }
        return null;
    }

    public String getHSCHostName() throws HSCCIMException {
        String string = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "-> getHSCHostName");
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new HSCCIMException("138F");
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("avpdhscD", "ret = " + string);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<- getHSCHostName");
        }
        return string;
    }

    public String getHSCOSName() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCOSName");
        }
        return "Embedded Operating Systems";
    }

    public String getHSCOSArchitecture() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCOSArchitecture");
        }
        return System.getProperty("os.arch");
    }

    public String getHSCOSVersion() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCOSVersion");
        }
        return "2.0";
    }

    public String getHSCLanguage() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCLanguage");
        }
        return Locale.getDefault().getLanguage();
    }

    public String getHSCLocale() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCLocale");
        }
        return Locale.getDefault().toString();
    }

    public String getHSCTotalMemory() {
        return "";
    }

    public String getHSCProductName() throws HSCCIMException {
        String string;
        int n;
        String string2 = null;
        String string3 = null;
        ResourceBundle resourceBundle = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "-> getHSCProductName");
        }
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.hsc.common.bundles.IBMNames");
            if (2 <= Trace.LEVEL) {
                Trace.trace("avpdhscF", "Loaded IBMNames");
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new HSCCIMException("1393");
        }
        string3 = string2 = this.getHSCModel();
        if (this.smbios.isSmbiosPresent() && (n = this.smbios.findNextStruct(-1, 1)) != -1 && (string = this.smbios.getSmbiosString(n, this.tables[n + 5])) != null && string.length() != 0) {
            string2 = string.trim();
        }
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("avpdhscT", "<- getHSCProductName");
            }
            return resourceBundle.getString(string3).trim();
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string2 = string3.substring(0, 4) + "-???";
                if (1 <= Trace.LEVEL) {
                    Trace.trace("avpdhscT", "<- getHSCProductName");
                }
                return resourceBundle.getString(string2).trim();
            }
            catch (MissingResourceException missingResourceException2) {
                try {
                    string2 = string3.substring(0, 4) + "-??? ";
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("avpdhscT", "<- getHSCProductName");
                    }
                    return resourceBundle.getString(string2).trim();
                }
                catch (MissingResourceException missingResourceException3) {
                    try {
                        string2 = string3 + "  ";
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("avpdhscT", "<- getHSCProductName");
                        }
                        return resourceBundle.getString(string2).trim();
                    }
                    catch (MissingResourceException missingResourceException4) {
                        return "";
                    }
                }
            }
        }
    }

    public byte[] getHSCVPD() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCVPD");
        }
        return this.VPDTable;
    }

    public long getHSCVPDLength() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<-> getHSCVPDLength");
        }
        return this.VPDTableLength;
    }

    private boolean readVPD() throws HSCCIMException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[131072];
        boolean bl = false;
        byte by = 0;
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "-> readVPD");
        }
        try {
            HMCPhysicalMem hMCPhysicalMem = new HMCPhysicalMem();
            hMCPhysicalMem.setAddress(917504L);
            hMCPhysicalMem.read(byArray);
            hMCPhysicalMem.close();
            bl = false;
            for (n2 = 0; n2 <= 131024; ++n2) {
                if (byArray[n2] != -86 || byArray[n2 + 1] != 85 || byArray[n2 + 2] != 86 || byArray[n2 + 3] != 80 || byArray[n2 + 4] != 68) continue;
                if (3 <= Trace.LEVEL) {
                    Trace.trace("avpdhscD", "Found VPD header at " + Integer.toHexString(917504 + n2));
                }
                n = HSCVPD.MakeUCHAR(byArray[n2 + 5]);
                by = 0;
                for (n3 = 13; n3 < 48; ++n3) {
                    by = (byte)(by + byArray[n2 + n3]);
                }
                if (by != 0) {
                    if (2 > Trace.LEVEL) continue;
                    Trace.trace("avpdhscF", "Invalid header checksum");
                    continue;
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("avpdhscF", "Found valid header checksum");
                }
                bl = true;
                break;
            }
            if (bl) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace("avpdhscF", "Reading VPD area");
                }
                this.VPDTableLength = n;
                this.VPDTable = new byte[n];
                for (n4 = 0; n4 < n; ++n4) {
                    this.VPDTable[n4] = byArray[n2 + n4];
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("avpdhscF", "VPD initialized successfully");
                }
                if (3 <= Trace.LEVEL) {
                    Trace.trace("avpdhscD", "VPDTableLength = " + this.VPDTableLength);
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace("avpdhscT", "<- readVPD");
                }
                return true;
            }
        }
        catch (IOException iOException) {
            throw new HSCCIMException("1394");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("avpdhscT", "<- readVPD");
        }
        return false;
    }

    public static final int MakeUCHAR(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("\nLoading VPD area\n");
            HSCVPD hSCVPD = new HSCVPD();
            if (hSCVPD.isVPDPresent()) {
                if (hSCVPD.getHSCVPDLength() != 0L) {
                    System.out.println("\nFound VPD, length = " + hSCVPD.getHSCVPDLength() + "\n");
                } else {
                    System.out.println("\nFound SIMBIOS, length = " + hSCVPD.smbios.length() + "\n");
                }
                System.out.println("VPD Model:       " + hSCVPD.getHSCModel() + "\n");
                System.out.println("VPD Serial No:   " + hSCVPD.getHSCSerialNumber() + "\n");
                System.out.println("VPD Motherboard: " + hSCVPD.getHSCMotherboard() + "\n");
                System.out.println("VPD BIOS:        " + hSCVPD.getHSCBIOS() + "\n");
                System.out.println("VPD Hostname:    " + hSCVPD.getHSCHostName() + "\n");
                System.out.println("VPD OS Name:     " + hSCVPD.getHSCOSName() + "\n");
                System.out.println("VPD OS Arch:     " + hSCVPD.getHSCOSArchitecture() + "\n");
                System.out.println("VPD OS Version:  " + hSCVPD.getHSCOSVersion() + "\n");
                System.out.println("VPD Language:    " + hSCVPD.getHSCLanguage() + "\n");
                System.out.println("VPD Locale:      " + hSCVPD.getHSCLocale() + "\n");
                System.out.println("VPD Memory:      " + hSCVPD.getHSCTotalMemory() + " Kb\n");
                System.out.println("VPD Product Name:" + hSCVPD.getHSCProductName() + "\n");
                System.out.println("\nExiting HSCVPD.main()\n\n");
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
        }
    }
}

